;coded by UEZ build 2015-08-07
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so ;/pe ;/rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GDIPlus.au3>
#include <GUIConstantsEx.au3>
#include <WindowsConstants.au3>

_GDIPlus_Startup()
Global Const $hBitmap_Master = _GDIPlus_BitmapCreateFromMemory(_Dali())
Global Const $iW = _GDIPlus_ImageGetWidth($hBitmap_Master), $iH = _GDIPlus_ImageGetHeight($hBitmap_Master)
Global Const $iWidth = 1200, $iHeight = 800, $iColor_Bg = 0x404040
Global Const $hGUI = GUICreate("GDI/GDI+ Test", $iWidth, $iHeight)
GUISetBkColor($iColor_Bg)
GUISetState()

Global $i, $j = 0, $f = 2, $l, $m = -3, $iStripes = 300, $aBitmap_Stripes[$iStripes], $aHBitmap_Stripes[$iStripes], $aDC_backbuffer[$iStripes], $aDC_obj[$iStripes]
Global $bFstart = True, $bLstart = False, $bMstart = True

Global Const $hDC = _WinAPI_GetDC($hGUI), $fBitmapPart = $iH / $iStripes
Global Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iWidth, $iHeight)
Global Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
Global Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
Global Const $hGfxCtxt = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
_GDIPlus_GraphicsSetSmoothingMode($hGfxCtxt, 2)
_GDIPlus_GraphicsSetTextRenderingHint($hGfxCtxt, 3)
Global Const $hPath = _GDIPlus_PathCreate(), $hFamily = _GDIPlus_FontFamilyCreate("Impact")
Global Const $hBrush_Text = _GDIPlus_BrushCreateSolid(0xC0FFFFFF), $hPen_Text = _GDIPlus_PenCreate(0xFF000000)
_GDIPlus_PathAddString($hPath, "AutoIt rulez!", _GDIPlus_RectFCreate(0, $iHeight - 80, 0, 0), $hFamily, 0, 72, 0)

Global $tRect = DllStructCreate("long [4]")
DllStructSetData($tRect, 1, 0.0, 1) ;left
DllStructSetData($tRect, 1, 0.0, 2) ;right
DllStructSetData($tRect, 1, $iWidth, 3) ;top
DllStructSetData($tRect, 1, $iHeight, 4) ;buttom
Global Const $iPtr = DllStructGetPtr($tRect), $hBrush = _WinAPI_CreateSolidBrush($iColor_Bg)

For $i = 0 To $iStripes - 1
	$aBitmap_Stripes[$i] = _GDIPlus_BitmapCloneArea($hBitmap_Master, 0, $i * $fBitmapPart, $iW, $fBitmapPart)
	$aHBitmap_Stripes[$i] = _GDIPlus_BitmapCreateHBITMAPFromBitmap($aBitmap_Stripes[$i])
	_GDIPlus_BitmapDispose($aBitmap_Stripes[$i])
	$aDC_backbuffer[$i] = _WinAPI_CreateCompatibleDC($hDC)
	$aDC_obj[$i] = _WinAPI_SelectObject($aDC_backbuffer[$i], $aHBitmap_Stripes[$i])
Next

AdlibRegister("Anim", 60)

HotKeySet("m", "M")
HotKeySet("l", "L")
HotKeySet("f", "F")

Do
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			AdlibUnRegister("Anim")
			_GDIPlus_ImageDispose($hBitmap_Master)
			For $i = 0 To $iStripes - 1
				_WinAPI_SelectObject($hDC, $aDC_obj[$i])
				_WinAPI_DeleteObject($aHBitmap_Stripes[$i])
			Next
			_WinAPI_SelectObject($hDC, $DC_obj)
			_WinAPI_DeleteObject($hHBitmap)
			_WinAPI_DeleteObject($hBrush)
			_WinAPI_ReleaseDC($hGUI, $hDC)
			_GDIPlus_GraphicsDispose($hGfxCtxt)
			_GDIPlus_PathDispose($hPath)
			_GDIPlus_BrushDispose($hBrush_Text)
			_GDIPlus_PenDispose($hPen_Text)
			_GDIPlus_FontFamilyDispose($hFamily)
			_GDIPlus_Shutdown()
			GUIDelete()
			Exit
	EndSwitch
Until False

Func M()
	$bMstart = ($bMstart = False) ? True : ($bMstart = True) ? False : ""
EndFunc

Func L()
	$bLstart = ($bLstart = False) ? True : ($bLstart = True) ? False : ""
EndFunc

Func F()
	$bFstart = ($bFstart = False) ? True : ($bFstart = True) ? False : ""
EndFunc

Func Anim()
	_WinAPI_FillRect($hDC_backbuffer, $iPtr, $hBrush) ;clear graphics
	For $i = 0 To $iStripes - 1
		$f = $bFstart ? Abs(Cos($i / 1500) + 1 + ATan(Sin($j / 4))) : 2
		$l = $bLstart ? (Sin($i / 100 + $j) * 1.1) : 1
		$m = $bMstart  ? (Cos(-$i / 80 + $j) * 1.25) : -3
		_WinAPI_StretchBlt($hDC_backbuffer, _
								 580 + $m * 64, _									;x
								 ($i * $fBitmapPart) * $f, _	  	;Y
								 $iW * $l, _							;w
								 ($fBitmapPart + 1) * $l * 160, _				;h
								 $aDC_backbuffer[$i], 0, 0, $iW, $fBitmapPart, $SRCCOPY)
	Next
    _GDIPlus_GraphicsFillPath($hGfxCtxt, $hPath, $hBrush_Text)
    _GDIPlus_GraphicsDrawPath($hGfxCtxt, $hPath, $hPen_Text)

	_WinAPI_BitBlt($hDC, 0, 0, $iWidth, $iHeight, $hDC_backbuffer, 0, 0, $SRCCOPY) ;copy bitmap to GUI
	If $bFstart Then $j += 0.105
EndFunc

;Code below was generated by: 'File to Base64 String' Code Generator v1.20 Build 2015-03-02

Func _Dali($bSaveBinary = False, $sSavePath = @ScriptDir)
	Local $Dali
	$Dali &= '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'
	$Dali &= '1rv1PcBqADQAERoEoyCyaL4yotjINRA+ZlhTzjSW9BeFm8Ugj2KLUgsa6WcSm9S5QbDkTMc9A6zy70M7M7XRDMcT9BccMdIjqLaXRb0k6ODCJHoHlHrwDiTDAIBJyxo+J0HfCi15pCBkAACiUD5fyI4NFoMjoDUSKCyLa3zloaqdnXyzoINAM802dAVDzJl3b5e6Nhn12ZzJFiyK3+S1o2ln0kdO0TSxwNgdTgcIW8fpd4IWlQAEgBkAyUKSoHy7BGSbjPzzWWGemGhnUEwurug0BKt2QNIppBz/ACPoWAee9RaYM7hM4NOIqGGjcTMVanUvXnhyxPaXO+JdmMI36NdMPu0qEktsCkGKSoCSMgGQHUgj5fEALUgi2ss9MNVcZDSllewWi+asKcYrpVOai54rBPQdfxzVDGS6TVHLjta8s+9cy9yHO95amOkQApIFhBikmkMGAwAJAIABgJZHy9BpDNJgWkiz0mKnnVtVyPZm9nwLEZXaTjn+P7VSHn7P+h8UcxuJsklQJhHc+811oLUDACAEgCwhYQQYoIWLIjDQpIFNuDiVkfLojIBgBmkwGQJWlyDp1nd8E1R2Sfy7TGggVLJoqmADNVnROVkT07ivTo6sli0qSElSALZWGCWIASBaFDhpMNJgIJUPkgj5fAyAAAAGEZGAjIEmMZqJeOUba155aG4nYe6LPqnQ98LcbcHFoMUEkGSUgBGOLQYSQkMwoNSQOpIASowgAfMEjIAADUkAAcG1b7vR5w6h314wU/byzgFT6bkHCe0WyxayMWtCh00LAhTYSQoMIA6tChKFoDUgx9KFBqQsMgYSVoPmKlSQjCgKHRzHd+3NsOPIfHpDTxIkx5YqRHeJAS4OAJHVoA6bZjqEoFBJDhJUOOMLHGwoQlaBYIwONGPm2sUQB8yWJDItIQK7LxrqR6DmQJxKkR5Q/IjyCRJZkAW0slLaWSAgxZJIWpkD6EAUSQPBp0WaFCw0B0IMUEoFGkxxxpY6aFHzQgz68DjagdG5z0k9E1NF5zPQnW/OXoomy4MkmvRHh52JKJJEsUAgWkkDyWzH0tmLU2B1bKx4kqAEpHDZMdCFgUlQs0AfW0o+YyVJACMGtyIJbLd0ek+g104nPMOE1+K+KkRXycuKskIQQtDYHFsKHQgDrjSxZpA4pBikkQZkYHG1C1odEkYFqQs+ZCFpCBkAyMV2Lj/qk2UuJKJj8d0kSIrpIeiPklbKSQllQsISOhpY6bax1yO6SA0ocNtQoJSOJSB1bKx5TbggwBakoPmkkAAAAoAnevwCdOAH3wBcgANwAcAAYAAABSgBawA3QBQAFuACFgDSgAOgBvgBGAGQB//EAC8QAAEDAwMDBAMBAAICAwAAAAECAwQABREGEiEQEyAUIjFBBxUwIyQyFjMlNED/2gAIAQEAAQUCcdLh3Vmt3XNBRFZOW0b6tUJKAEU3xTJJSDklBJDJwBlwNL3dug2acjoqbbSozbEhSrhp94VIt7rAC1JR3OUe+gzlzbyU8wwgvaSu67tYwqt1A0FVms9fs0fMUgHMGPUT/pikVHXmkLxSUGg0FU2lCShk0Rtoj3bVrrtKosJVRYQurlp9KlXS0KaefjlqskFhzaXMZA3Bpjn8bO5sQ+Rz0FffUcmj5JTmmuajgJps4MfcaR7SFgCOcU0sgA1hWUpyUHNONU2jFelwUtkUrKaA4IWakRELq8WPvm7Wb0VBOCtRWruYML/Rj8cgJsg56jqOpPJ8cUOKYbUox0hIChmO6RTJzQfCFsOAU2FGo7LaE9vAJCShPJQlVBOFpbwTQSKWMjGC8nIwSLnZUv0nS2VTrauO5jmC6hKtDjZbUY29B/QfDfBQomkJWotnbTJKiwvuAIwpgBCIisqYVmnBhIbLgaSvZ2VlKGl0hJp1pKATklsiv+tK4Lp2UAMO4CZlqRKF2s7kNSTitI3+Lb7XGdD7HQD+goLNNECgsYYeTmIyTWzYpgbinalLCg4GXCgJ'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= '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'
	$Dali &= 'PrfxPW8BnPYHsaWAO+vtkHOzPOAo2UCNnmtTtI+ieBiG5camaEenSYsBkNi2TgkWh3lUpl8S0Pgpe9WwxPF7VyCJ3wfvNTHByaUnqfkGpDC/YGsd+fladzdzlrC2E87YMCqoZ22oCOQS+a21Jz1iuSAGWC8O8QMy9PGmV1zbPiqB8C4zrdy+d1Oh9mDmx27TSGHeovAfUDCZkdcDV/8A3KXqjB1dkK8kUBlY+SEHIGPTBkXKjmhaTxjkMbaPPSr1ht/UZjrIKGdtpph+de4qnb5sxqobSksj8nhmo7lgG6jFz5KYj7/cTHlpCKuQ0f8AQ6+rXZM9nsZhpauab9/OsTzh3Dj8dwMe52fqhq98dw1co2oQ8WxkOhiGT1Yw60Pzcxkx3JytXwVdX0JR5HmFoTof41CNH6dsWcgwrxchlaF1TzCCc8Vfnrq1Yea7u1hn0IYb1gHO4J4hQ0tobjYXhL/3MqyjJZCeigqCcLPWbKg863OiUyvoJf0hepLqyfv/ADd40/2nnl0osRvn8kXhqEGlQ1iA7R0uXkpoNQj2IFxZOKBeSfohMRcpAK31aatXdB8tI9rQJWTiIRjedhlYAwzkH9NFJxC/kcFGnUiD6LivR6wlWV4Fiokh23sEnQ50A8nLjTMr1OdpJzLLTdLjccn5RPSPxTYXroX6MIE0DKyBMcdIpl4xtKjFWRBmdspA5w15qQWAzQ8LB5aJMeaTwiM1Kp8my91Vjy+umB2XvQeCmkHeDSgzRRCFxS0D02xVlBU9z6Kgqv6QGb+AIsbWQf8AR7fn/I7qj8CuG6CEzc8960R224LM5/NcMmLuJ656MGalBgmoAwLgBqZzqK1ULJrdKysbhW0ocqxamB7T4k7hy/rVGSGG/v1qmr7C3sdmWqkTYxQXJOAg/ocqDqjZ2piSqpLK0QwSN095OvXTLDwnQmoLXobw0u2SEBWNxSf0vwv9sK5rP8ptkiEU0zxkyFvq1IoF1JiBPttGVDEeD3k0qN4nzjO1uUWAoBFyg+Mu8m/W4HGeYncNKi3HikaXSLfMvlUlD9LlVUVZSYHKdfoo8MIf8JykRHT4ajeYp9kUMg8ugUWCGtH+EYXrSszlALhZe55SQqpMOd/CkN7zo4oDsJb5civ5QKs70jXCw7ZFIVWQFku0qEqxcNtWVDb3nDH6B0Jqs5LRoJODyazkjIeQiIgZ65mzA0KlsZ3ZIgTo1mo7j6Gb/wDyz4NBjZ39QzObiSWUD88KXjdKdBPU5+Rq8wnAS+k5k5CeeOSQOXCkSjsxiGHvisGJY7r0XzGu5aV2oXIecp7D339Z0QOAsqOB0nDbYiWiu+x1RWVcEwC0IPFmkjlmQUNZWIUQ0AI4C7Bq3OKfhMPR8IanP0rKNzGwbkg7HaQ23e4rExtNKxHlLSuRDj4GKKGN94ERdE33+7FM1bNbAfN5qMQlcryUFfyxrkM4e4lUeqVUFb0O+XTCYzgiYCtroBvieFsz5aZwjm+aunfuOjf+4ab7LVi6oHiMcqSMNR+JODMqbHh5456PsxINY7mF8JVc0FmIBbXxGAHjT4EsByiiJU1tAyvmIDpUOWoQ+XUPX+Gr4tzViqUfRxhZc0LgmdEXdGwXP+WzAGuHEWJjA3rnGNR/CsN+0yKHnmP/AAhxdGZxwbZijZae2pRiKnib3pQfxL63wwxhWRK8KeUiKBqUf8dvIE6k6UbzpnnWoj+uH3TXPRXjMEsFSijBa5ySKfE2oAxUmCzu5vYaiRFcfnHgD9eewHM1ZFqfvI4k/wARwqhAvVVtrN6186jNu6Tsq9NKbB3p700sKl3zjUect6o5wvImJVrjFdED8ZEFuVMEpHq7Zkqg+k9irQGz73ExzUpZUdMK35Jl4HnRvEjSoyVG7Tf5U6LnbG+S9T721VM4v6WlV0VC4Y8RJ+5kUHYKiG+axlE8MiqMQUvKfSVCwfMlCBSvg7/imsujPgLneqDPB2nRH21DdSs5bUqdY2nfGubzNfRO'
	$Dali &= 'oGmNYKqGj3nKoxHTmBxe/VgyW2PKcl7GdDIn3cnlyqwJKvSdQO5SYnQeU/zU9Zi9+FtETSa4p8RNodpk9I+XueQ3XB5/kMkkT1B3Jq0UZtAPQso/JVo/zNLw5uYsLMdL3X/X/d6H0nM9H58458IGhW2DdHmvRTCdW5lWhk6UB6hnIzOpKvW5Xho//A6xtA2wWGhp2PH3QCXohNOpllarQftbThDw0xzpj2+yUjqzlCFYfjjJFC/Yih+UwUBX8k3P9x8VKJLsfqHHcQspetflRqhwt3HXjCcFsNQJVpX86Uj3tUuZJKqbTB4tli4Oi7IVGLuVgXbN43TumO47JDIXTSVt50bjYH1pYBZ4e9qLmCeD1mmRsL1g+PAbhooOGjEhcMF5S3v6RqA7UEpDKNqz7O9RtQnVvJm+ctrOBaFMu6JAfyw0Z/HTXeA8LSLx4hIOZ5GCR2nkYnE0UimaKOu/6RPXzEXnQJpp1pL4mM/V/LSGpkhhdqPl9rs9HhGfNp3phaBXDQcUP4aIAk4RyYZGh+SlG+nOp+nMgxVdxzQWWcPI9cPATRw+P29utLdjzKI6X93ySrQ51YnSj8WXjoreHjKXlvMdzZPY6or3uA86pGFF3sBX0t+dSVaPMPQ6z/oiwddoc6Ua+jJcbtqx6FV8/oBnpod3AlXqcc6ndXV12gWCHQhJJpTOfdt7dD1w8VbfAr+jIqsDxq/g7pfnjPG6L2EaCWhpmUBbdYZWpIJTcVVk8pIwYtGrqcMmWhAimMnRsgWMiKp8ipBQlcMCUnRmVC2LrQVp+fMnQ1vfkimQ1nWi+rPyqf/Z'
	Local $bString = _WinAPI_Base64Decode($Dali)
	If @error Then Return SetError(1, 0, 0)
	$bString = Binary($bString)
	If $bSaveBinary Then
		Local Const $hFile = FileOpen($sSavePath & "\salvador-dali.jpg", 18)
		If @error Then Return SetError(2, 0, $bString)
		FileWrite($hFile, $bString)
		FileClose($hFile)
	EndIf
	Return $bString
EndFunc   ;==>_Dali

Func _WinAPI_Base64Decode($sB64String)
	Local $aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "ptr", 0, "dword*", 0, "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(1, 0, "")
	Local $bBuffer = DllStructCreate("byte[" & $aCrypt[5] & "]")
	$aCrypt = DllCall("Crypt32.dll", "bool", "CryptStringToBinaryA", "str", $sB64String, "dword", 0, "dword", 1, "struct*", $bBuffer, "dword*", $aCrypt[5], "ptr", 0, "ptr", 0)
	If @error Or Not $aCrypt[0] Then Return SetError(2, 0, "")
	Return DllStructGetData($bBuffer, 1)
EndFunc   ;==>_WinAPI_Base64Decode